<?php
/**
 * ZenWind: Customizer
 */
if ( ! function_exists( 'zenwind_customize_register' ) ) :
	/**
	 * Add postMessage support for site title and description for the Theme Customizer.
	 *
	 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
	 */
	function zenwind_customize_register( $wp_customize ) {

		/**
	     * Add Animations Section
	     */
	    $wp_customize->add_section(
	        'zenwind_animations_display',
	        array(
	            'title'       => __( 'Animations', 'zenwind' ),
	            'capability'  => 'edit_theme_options',
	        )
	    );

	    // Add display Animations option
	    $wp_customize->add_setting(
	            'zenwind_animations_display',
	            array(
	                    'default'           => 0,
	                    'sanitize_callback' => 'zenwind_sanitize_checkbox',
	            )
	    );

	    $wp_customize->add_control( new WP_Customize_Control( $wp_customize,
	                        'zenwind_animations_display',
	                            array(
	                                'label'          => __( 'Enable Animations', 'zenwind' ),
	                                'section'        => 'zenwind_animations_display',
	                                'settings'       => 'zenwind_animations_display',
	                                'type'           => 'checkbox',
	                            )
	                        )
	    );

	    /**
		 * Add Slider Section
		 */
		$wp_customize->add_section(
			'zenwind_slider_section',
			array(
				'title'       => __( 'Slider', 'zenwind' ),
				'capability'  => 'edit_theme_options',
			)
		);
		
		// Add display slider option
		$wp_customize->add_setting(
				'zenwind_slider_display',
				array(
						'default'           => 1,
						'sanitize_callback' => 'zenwind_sanitize_checkbox',
				)
		);

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'zenwind_slider_display',
								array(
									'label'          => __( 'Display Slider on a Static Front Page', 'zenwind' ),
									'section'        => 'zenwind_slider_section',
									'settings'       => 'zenwind_slider_display',
									'type'           => 'checkbox',
								)
							)
		);

		for ($i = 1; $i <= 3; ++$i) {
		
			$slideImageId = 'zenwind_slide'.$i.'_image';
			$defaultSliderImagePath = get_template_directory_uri().'/assets/images/'.$i.'.jpg';
			
			// Add Slide Background Image
			$wp_customize->add_setting( $slideImageId,
				array(
					'default' => $defaultSliderImagePath,
					'sanitize_callback' => 'zenwind_sanitize_url'
				)
			);

			$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, $slideImageId,
					array(
						'label'   	 => sprintf( esc_html__( 'Slide #%s Image', 'zenwind' ), $i ),
						'section' 	 => 'zenwind_slider_section',
						'settings'   => $slideImageId,
					) 
				)
			);
		}

		/**
		 * Add Footer Section
		 */
		$wp_customize->add_section(
			'zenwind_footer_section',
			array(
				'title'       => __( 'Footer', 'zenwind' ),
				'capability'  => 'edit_theme_options',
			)
		);
		
		// Add Footer Copyright Text
		$wp_customize->add_setting(
			'zenwind_footer_copyright',
			array(
			    'default'           => '',
			    'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'zenwind_footer_copyright',
	        array(
	            'label'          => __( 'Copyright Text', 'zenwind' ),
	            'section'        => 'zenwind_footer_section',
	            'settings'       => 'zenwind_footer_copyright',
	            'type'           => 'text',
	            )
	        )
		);
	}
endif; // zenwind_customize_register
add_action( 'customize_register', 'zenwind_customize_register' );

if ( ! function_exists( 'zenwind_sanitize_checkbox' ) ) :
	/**
	 * Sanitization callback for 'checkbox' type controls. This callback sanitizes `$checked`
	 * as a boolean value, either TRUE or FALSE.
	 *
	 * @param bool $checked Whether the checkbox is checked.
	 * @return bool Whether the checkbox is checked.
	 */
	function zenwind_sanitize_checkbox( $checked ) {
		// Boolean check.
		return ( ( isset( $checked ) && true == $checked ) ? true : false );
	}
endif; // zenwind_sanitize_checkbox

if ( ! function_exists( 'zenwind_sanitize_url' ) ) :

	function zenwind_sanitize_url( $url ) {
		return esc_url_raw( $url );
	}

endif; // zenwind_sanitize_url
