<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "body-content-wrapper" div.
 *
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
	<head>
		<meta charset="<?php bloginfo('charset'); ?>" />
		<?php
            if ( is_singular() && pings_open() ) :
                printf( '<link rel="pingback" href="%s">' . "\n", get_bloginfo( 'pingback_url' ) );
            endif;
        ?>
		<meta name="viewport" content="width=device-width" />
		<?php wp_head(); ?>
	</head>
	<body <?php body_class(); ?>>
		<?php wp_body_open(); ?>
		<a class="skip-link screen-reader-text" href="#main-content-wrapper">
			<?php _e( 'Skip to content', 'zenoffice' ); ?>
		</a>
		<div id="body-content-wrapper">
			<div id="header-top">
				<div id="header-top-inner">
					<div id="sb-search" class="sb-search">
		                <?php get_search_form(); ?>
		            </div>

		            <ul class="header-social-widget">
						<?php zenoffice_show_social_sites(); ?>
					</ul>
					<div class="clear"></div>
				</div>
			</div>

			<?php
				// display shopping cart
				if ( class_exists( 'WooCommerce' ) ) :
				
					global $woocommerce;
			?>
					<div id="header-cart-wrapper">
						<a class="cart-contents-icon" href="<?php echo wc_get_cart_url(); ?>" title="<?php echo esc_attr( _( 'View your shopping cart', 'zenoffice' ) ); ?>">
						<span class="cart-items-count">
							<?php echo sprintf ( _n( '%d', '%d', WC()->cart->get_cart_contents_count() ), WC()->cart->get_cart_contents_count() ); ?>
						</span>
						 <?php echo WC()->cart->get_cart_total(); ?></a>
						<div id="cart-popup-content"><div class="widget_shopping_cart_content"></div></div>
					</div>
			<?php
				endif;
			?>
			<header id="header-main-fixed">

				<div id="header-content-wrapper">

					<div id="header-logo">
						<?php
							if ( function_exists( 'the_custom_logo' ) ) :

								the_custom_logo();

							endif;

							$header_text_color = get_header_textcolor();

						    if ( 'blank' !== $header_text_color ) :
						?>    
						        <div id="site-identity">

						        	<a href="<?php echo esc_url( home_url('/') ); ?>"
						        		title="<?php echo esc_attr( get_bloginfo('name') ); ?>">

						        		<h1 class="entry-title">
						        			<?php echo esc_html( get_bloginfo('name') ); ?>
										</h1>
						        	</a>
						        	<strong>
						        		<?php echo esc_html( get_bloginfo('description') ); ?>
						        	</strong>
						        </div>
						<?php
						    endif;
						?>
					</div><!-- #header-logo -->

					<div class="clear">
					</div><!-- .clear -->

					<nav id="navmain">
						<?php wp_nav_menu( array( 'theme_location' => 'primary',
												  'fallback_cb'    => 'wp_page_menu',
												  
												  ) ); ?>
					</nav><!-- #navmain -->
					
					<div class="clear">
					</div><!-- .clear -->

				</div><!-- #header-content-wrapper -->

			</header><!-- #header-main-fixed -->
			<div id="header-spacer">
				&nbsp;
			</div>

			

