<?php
/**
 * Featured Posts section
 *
 * This is the template for the content of featured_posts section
 *
 * @package Theme Palace
 * @subpackage Businesszen Dairy
 * @since Businesszen Dairy 1.0.0
 */
if ( ! function_exists( 'businesszen_dairy_add_featured_posts_section' ) ) :
    /**
    * Add featured_posts section
    *
    *@since Businesszen Dairy 1.0.0
    */
    function businesszen_dairy_add_featured_posts_section() {
        
        // Check if featured_posts is enabled on frontpage
        if ( get_theme_mod( 'featured_posts_section_enable' ) == false ) {
            return false;
        }

        // Get featured_posts section details
        $section_details = array();
        $section_details = apply_filters( 'businesszen_dairy_filter_featured_posts_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render featured_posts section now.
        businesszen_dairy_render_featured_posts_section( $section_details );
    }

endif;

if ( ! function_exists( 'businesszen_dairy_get_featured_posts_section_details' ) ) :
    /**
    * featured_posts section details.
    *
    * @since Businesszen Dairy 1.0.0
    * @param array $input featured_posts section details.
    */
    function businesszen_dairy_get_featured_posts_section_details( $input ) {
        $content  = array();
        $post_ids = array();
        for ( $i = 1; $i <= 3; $i++ ) {
            if ( ! empty( get_theme_mod( 'featured_posts_content_post_'.$i ) ) )
                $post_ids[] = get_theme_mod( 'featured_posts_content_post_'.$i );
        }

        $args = array(
            'post_type'         => 'post',
            'post__in'          => ( array ) $post_ids,
            'posts_per_page'    => absint( 3 ),
            'orderby'           => 'post__in',
        );

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();
                    $page_post['excerpt']   = businesszen_trim_content( 25 );
                    $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// featured_posts section content details.
add_filter( 'businesszen_dairy_filter_featured_posts_section_details', 'businesszen_dairy_get_featured_posts_section_details' );


if ( ! function_exists( 'businesszen_dairy_render_featured_posts_section' ) ) :
  /**
   * Start featured_posts section
   *
   * @return string featured_posts content
   * @since Businesszen Dairy 1.0.0
   *
   */
   function businesszen_dairy_render_featured_posts_section( $content_details = array() ) {

        if ( empty( $content_details ) ) {
            return;
        } ?>

            <div id="businesszen_featured_posts_section" class="relative page-section">
                <div class="wrapper">
                    <div class="section-contnet col-3 clear">
                        <?php foreach ($content_details as $content ): ?>
                            <article>
                                <div class="featured-post-item">
                                    <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                        <a href="#" class="post-thumbnail-link"></a>
                                    </div><!-- .featured-image -->

                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ) ; ?>"><?php echo esc_html( $content['title'] ) ; ?></a></h2>
                                    </header>
                                </div><!-- .featured-post-item -->
                            </article>
                        <?php endforeach; ?>
                    </div><!-- .col-3 -->
                </div><!-- .wrapper -->
            </div><!-- #businesszen_featured_posts_section -->
              
<?php    }
endif;