<?php
/**
 * CTA section
 *
 * This is the template for the content of about section
 *
 * @package Theme Palace
 * @subpackage Businesszen
 * @since Businesszen 1.0.0
 */
if ( ! function_exists( 'businesszen_dairy_add_cta_section' ) ) :
    /**
    * Add about section
    *
    *@since Businesszen 1.0.0
    */
    function businesszen_dairy_add_cta_section() {
    	$options = businesszen_get_theme_options();
        // Check if cta is enabled on frontpage
        $cta_enable = apply_filters( 'businesszen_section_status', true, 'cta_section_enable' );

        if ( true !== $cta_enable ) {
            return false;
        }
        // Get about section details
        $section_details = array();
        $section_details = apply_filters( 'businesszen_dairy_filter_cta_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render about section now.
        businesszen_dairy_render_cta_section( $section_details );
    }
endif;

if ( ! function_exists( 'businesszen_dairy_get_cta_section_details' ) ) :
    /**
    * about section details.
    *
    * @since Businesszen 1.0.0
    * @param array $input about section details.
    */
    function businesszen_dairy_get_cta_section_details( $input ) {
        $options = businesszen_get_theme_options();
        
        $content = array();
        $page_id = ! empty( $options['cta_content_page'] ) ? $options['cta_content_page'] : '';
                $args = array(
                    'post_type'         => 'page',
                    'page_id'           => $page_id,
                    'posts_per_page'    => 1,
                    );

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['title']     = get_the_title();
                    $page_post['excerpt']   = businesszen_trim_content( 30 );
                    $page_post['url']       = get_the_permalink();

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// about section content details.
add_filter( 'businesszen_dairy_filter_cta_section_details', 'businesszen_dairy_get_cta_section_details' );


if ( ! function_exists( 'businesszen_dairy_render_cta_section' ) ) :
  /**
   * Start about section
   *
   * @return string about content
   * @since Businesszen 1.0.0
   *
   */
   function businesszen_dairy_render_cta_section( $content_details = array() ) {
        $options = businesszen_get_theme_options();
        $image  = ($options['cta_image']) ? $options['cta_image'] : '';

        if ( empty( $content_details ) ) {
            return;
        } 
        ?>

        <?php foreach ( $content_details as $content ): ?>

            <div id="businesszen_call_to_action_section" class="relative page-section" style="background-image: url('<?php echo esc_url( $image ); ?>');">
                <div class="overlay"></div>
                <div class="wrapper">

                    <?php if( !empty( $content['title'] ) ): ?>

                        <header class="entry-header">
                            <h2 class="entry-title"><?php echo esc_html( $content['title'] ); ?></h2>
                        </header>

                        <?php

                        endif;

                        if( !empty( $content['excerpt'] ) ):

                            ?>

                        <div class="entry-content">
                            <p><?php echo esc_html( $content['excerpt'] ); ?></p>
                        </div><!-- .entry-content -->

                        <?php

                        endif;

                            if( !empty( get_theme_mod( 'cta_btn_url' ) ) ) :

                                ?>

                                <div class="read-more">
                                    <a href="<?php echo esc_url( get_theme_mod( 'cta_btn_url' ) );?>" class="btn"><?php echo esc_html( get_theme_mod( 'cta_btn_title', __( 'View Stories', 'businesszen-dairy' ) ) ); ?></a>
                                </div><!-- .read-more -->
                            <?php

                            endif;

                        ?>

                    </div><!-- .wrapper -->
                </div><!-- #businesszen_dairy_call_to_action_section -->

                <?php 

                endforeach;

            }

    endif;