<?php
// Add Subscribe section
$wp_customize->add_section( 'businesszen_subscribe_section',
    array(
        'title'             => esc_html__( 'Subscribe','businesszen-dairy' ),
        'description'       => esc_html__( 'Subscribe Section options.', 'businesszen-dairy' ),
        'panel'             => 'businesszen_front_page_panel',
        'priority'          => 52,
    )
);

// Subscribe content enable control and setting
$wp_customize->add_setting( 'subscribe_section_enable',
    array(
        'default'           =>  false,
        'sanitize_callback' => 'businesszen_sanitize_switch_control',
    )
);

$wp_customize->add_control( new Businesszen_Dairy_Switch_Control( $wp_customize,
    'subscribe_section_enable',
        array(
            'label'             => esc_html__( 'Subscribe Section Enable', 'businesszen-dairy' ),
            'section'           => 'businesszen_subscribe_section',
            'on_off_label'      => businesszen_switch_options(),
        ) 
    )
);

// Subscription image setting and control.
$wp_customize->add_setting( 'subscription_bg_image', array(
    'sanitize_callback' => 'businesszen_sanitize_image'
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'subscription_bg_image',
        array(
        'label'             => esc_html__( 'Background Image', 'businesszen-dairy' ),
        'section'           => 'businesszen_subscribe_section',
        'active_callback'   => 'businesszen_dairy_is_subscribe_section_enable',
) ) );

// subscription title setting and control
$wp_customize->add_setting( 'subscription_title', array(
    'sanitize_callback' => 'sanitize_text_field',
    'default'           => esc_html__( 'Subscribe Now', 'businesszen-dairy' ),
    'transport'         => 'postMessage',
) );

$wp_customize->add_control( 'subscription_title', array(
    'label'             => esc_html__( 'Title', 'businesszen-dairy' ),
    'section'           => 'businesszen_subscribe_section',
    'active_callback'   => 'businesszen_dairy_is_subscribe_section_enable',
    'type'              => 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'subscription_title', array(
        'selector'            => '#businesszen_subscribe_section .entry-header h2',
        'settings'            => 'subscription_title',
        'container_inclusive' => false,
        'fallback_refresh'    => true,
        'render_callback'     => 'businesszen_dairy_subscription_title_partial',
    ) );
}

// subscription description setting and control
$wp_customize->add_setting( 'subscription_description', array(
    'sanitize_callback' => 'wp_kses_post',
    'default'           => esc_html__( 'Almost two years ago I sat down in front of a computer screen, in an open office space, waiting. I was nervous, eager to start and terrified.', 'businesszen-dairy' ),  
    'transport'         => 'postMessage',
) );

$wp_customize->add_control( 'subscription_description', array(
    'label'             => esc_html__( 'Description', 'businesszen-dairy' ),
    'section'           => 'businesszen_subscribe_section',
    'active_callback'   => 'businesszen_dairy_is_subscribe_section_enable',
    'type'              => 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'subscription_description', array(
        'selector'            => '#businesszen_subscribe_section .entry-content p',
        'settings'            => 'subscription_description',
        'container_inclusive' => false,
        'fallback_refresh'    => true,
        'render_callback'     => 'businesszen_dairy_subscription_description_partial',
    ) );
}

// subscription btn title setting and control
$wp_customize->add_setting( 'subscription_btn_title', array(
    'sanitize_callback' => 'sanitize_text_field',
    'default'           => esc_html__( 'Subscribe', 'businesszen-dairy' ),
    'transport'         => 'postMessage',
) );

$wp_customize->add_control( 'subscription_btn_title', array(
    'label'             => esc_html__( 'Button Label', 'businesszen-dairy' ),
    'section'           => 'businesszen_subscribe_section',
    'active_callback'   => 'businesszen_dairy_is_subscribe_section_enable',
    'type'              => 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'subscription_btn_title', array(
        'selector'            => '#businesszen_subscribe_section .wp-block-button__link',
        'settings'            => 'subscription_btn_title',
        'container_inclusive' => false,
        'fallback_refresh'    => true,
        'render_callback'     => 'businesszen_dairy_subscription_btn_title_partial',
    ) );
}