<?php
/**
 * Featured Posts Section options
 *
 * @package Theme Palace
 * @subpackage Businesszen Dairy
 * @since Businesszen Dairy 1.0.0
 */

// Add Featured Posts section
$wp_customize->add_section( 'businesszen_featured_posts_section',
    array(
        'title'             => esc_html__( 'Featured Posts','businesszen-dairy' ),
        'description'       => esc_html__( 'Featured Posts Section options.', 'businesszen-dairy' ),
        'panel'             => 'businesszen_front_page_panel',
        'priority'          => 21,
    )
);

// Featured Posts content enable control and setting
$wp_customize->add_setting( 'featured_posts_section_enable',
    array(
        'default'           =>  false,
        'sanitize_callback' => 'businesszen_sanitize_switch_control',
    )
);

$wp_customize->add_control( new Businesszen_Dairy_Switch_Control( $wp_customize,
    'featured_posts_section_enable',
        array(
            'label'             => esc_html__( 'Featured Posts Section Enable', 'businesszen-dairy' ),
            'section'           => 'businesszen_featured_posts_section',
            'on_off_label'      => businesszen_switch_options(),
        ) 
    )
);

for ( $i = 1; $i <= 3; $i++ ) :

    // latest_post posts drop down chooser control and setting
    $wp_customize->add_setting( 'featured_posts_content_post_' . $i,
        array(
            'sanitize_callback' => 'businesszen_sanitize_page',
        )
    );

    $wp_customize->add_control( new Businesszen_Dairy_Dropdown_Chooser( $wp_customize,
        'featured_posts_content_post_' . $i,
            array(
                'label'             => sprintf( esc_html__( 'Select Post %d', 'businesszen-dairy' ), $i ),
                'section'           => 'businesszen_featured_posts_section',
                'choices'           => businesszen_post_choices(),
                'active_callback'   => 'businesszen_dairy_is_featured_posts_section_enable',
            ) 
        )
    );

    //latest_post separator
    $wp_customize->add_setting('featured_posts_separator'. $i,
        array(
            'sanitize_callback'      => 'businesszen_sanitize_html',
        )
    );

    $wp_customize->add_control(new Businesszen_Dairy_Customize_Horizontal_Line($wp_customize,
        'featured_posts_separator'. $i,
            array(
                'active_callback'       => 'businesszen_dairy_is_featured_posts_section_enable',
                'type'                  =>'hr',
                'section'               =>'businesszen_featured_posts_section',
            )
        )
    );
    
endfor;