<?php

function businesszen_dairy_customize_register( $wp_customize ) {

class Businesszen_Dairy_Switch_Control extends WP_Customize_Control{

		public $type = 'switch';

		public $on_off_label = array();

		public function __construct( $manager, $id, $args = array() ){
	        $this->on_off_label = $args['on_off_label'];
	        parent::__construct( $manager, $id, $args );
	    }

		public function render_content(){
	    ?>
		    <span class="customize-control-title">
				<?php echo esc_html( $this->label ); ?>
			</span>

			<?php if( $this->description ){ ?>
				<span class="description customize-control-description">
				<?php echo wp_kses_post( $this->description ); ?>
				</span>
			<?php } ?>

			<?php
				$switch_class = ( $this->value() == 'true' ) ? 'switch-on' : '';
				$on_off_label = $this->on_off_label;
			?>
			<div class="onoffswitch <?php echo esc_attr( $switch_class ); ?>">
				<div class="onoffswitch-inner">
					<div class="onoffswitch-active">
						<div class="onoffswitch-switch"><?php echo esc_html( $on_off_label['on'] ) ?></div>
					</div>

					<div class="onoffswitch-inactive">
						<div class="onoffswitch-switch"><?php echo esc_html( $on_off_label['off'] ) ?></div>
					</div>
				</div>	
			</div>
			<input <?php $this->link(); ?> type="hidden" value="<?php echo esc_attr( $this->value() ); ?>"/>
			<?php
	    }
	}

	class Businesszen_Dairy_Dropdown_Chooser extends WP_Customize_Control{

		public $type = 'dropdown_chooser';

		public function render_content(){
			if ( empty( $this->choices ) )
	                return;
			?>
	            <label>
	                <span class="customize-control-title">
	                	<?php echo esc_html( $this->label ); ?>
	                </span>

	                <?php if($this->description){ ?>
		            <span class="description customize-control-description">
		            	<?php echo wp_kses_post($this->description); ?>
		            </span>
		            <?php } ?>

	                <select class="businesszen-dairy-chosen-select" <?php $this->link(); ?>>
	                    <?php
	                    foreach ( $this->choices as $value => $label )
	                        echo '<option value="' . esc_attr( $value ) . '"' . selected( $this->value(), $value, false ) . '>' . esc_html( $label ) . '</option>';
	                    ?>
	                </select>
	            </label>
			<?php
		}
	}


	//Custom control for horizontal line
	Class Businesszen_Dairy_Customize_Horizontal_Line extends WP_Customize_Control {

		public $type = 'hr';

		public function render_content() {
			?>
			<div>
				<hr style="border: 1px dotted #72777c;" />
			</div>
			<?php
		}
	}

	//customizer section
	require get_theme_file_path() . '/inc/customizer/featured-posts.php';
	require get_theme_file_path() . '/inc/customizer/popular-posts.php';
	require get_theme_file_path() . '/inc/customizer/cta.php';
	require get_theme_file_path() . '/inc/customizer/recent-posts.php';
	require get_theme_file_path() . '/inc/customizer/subscribe.php';

}
add_action( 'customize_register', 'businesszen_dairy_customize_register' );

/*=============Active Callback=====================*/

function businesszen_dairy_is_featured_posts_section_enable( $control ) {
	return ( $control->manager->get_setting( 'featured_posts_section_enable' )->value() );
}

function businesszen_dairy_is_popular_posts_section_enable( $control ) {
	return ( $control->manager->get_setting( 'popular_posts_section_enable' )->value() );
}

function businesszen_dairy_is_recent_posts_section_enable( $control ) {
	return ( $control->manager->get_setting( 'recent_posts_section_enable' )->value() );
}

function businesszen_dairy_is_subscribe_section_enable( $control ) {
	return ( $control->manager->get_setting( 'subscribe_section_enable' )->value() );
}

/*=============Partial Refresh=====================*/

if ( ! function_exists( 'businesszen_dairy_recent_posts_title_partial' ) ) :
    // recent_posts_title
    function businesszen_dairy_recent_posts_title_partial() {
        return esc_html( get_theme_mod( 'recent_posts_title' ) );
    }
endif;

if ( ! function_exists( 'businesszen_dairy_recent_posts_sub_title_partial' ) ) :
    // recent_posts_sub_title
    function businesszen_dairy_recent_posts_sub_title_partial() {
        return esc_html( get_theme_mod( 'recent_posts_sub_title' ) );
    }
endif;

if ( ! function_exists( 'businesszen_dairy_subscription_title_partial' ) ) :
    // subscription_title
    function businesszen_dairy_subscription_title_partial() {
        return esc_html( get_theme_mod( 'subscription_title' ) );
    }
endif;

if ( ! function_exists( 'businesszen_dairy_subscription_description_partial' ) ) :
    // subscription_description
    function businesszen_dairy_subscription_description_partial() {
        return esc_html( get_theme_mod( 'subscription_description' ) );
    }
endif;

if ( ! function_exists( 'businesszen_dairy_subscription_description_partial' ) ) :
    // subscription_description
    function businesszen_dairy_subscription_description_partial() {
        return esc_html( get_theme_mod( 'subscription_description' ) );
    }
endif;

if ( ! function_exists( 'businesszen_dairy_subscription_btn_title_partial' ) ) :
    // subscription_btn_title
    function businesszen_dairy_subscription_btn_title_partial() {
        return esc_html( get_theme_mod( 'subscription_btn_title' ) );
    }
endif;

if ( ! function_exists( 'businesszen_dairy_cta_btn_title_partial' ) ) :
    // cta_btn_title
    function businesszen_dairy_cta_btn_title_partial() {
        return esc_html( get_theme_mod( 'cta_btn_title' ) );
    }
endif;