<?php
	/**
	 * The header for our theme.
	 *
	 * This is the template that displays all of the <head> section and everything up until <div id="content">
	 *
	 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
	 *
	 * @package Theme Palace
	 * @subpackage Businesszen
	 * @since Businesszen 1.0.0
	 */

	/**
	 * businesszen_doctype hook
	 *
	 * @hooked businesszen_doctype -  10
	 *
	 */
	do_action( 'businesszen_doctype' );

?>
<head>
<?php
	/**
	 * businesszen_before_wp_head hook
	 *
	 * @hooked businesszen_head -  10
	 *
	 */
	do_action( 'businesszen_before_wp_head' );

	wp_head(); 
?>
</head>

<body <?php body_class(); ?>>

<?php do_action( 'wp_body_open' ); ?>

<?php
	/**
	 * businesszen_page_start_action hook
	 *
	 * @hooked businesszen_page_start -  10
	 *
	 */
	do_action( 'businesszen_page_start_action' ); 

	/**
	 * businesszen_loader_action hook
	 *
	 * @hooked businesszen_loader -  10
	 *
	 */
	do_action( 'businesszen_before_header' );

	/**
	 * businesszen_header_action hook
	 *
	 * @hooked businesszen_header_start -  10
	 * @hooked businesszen_site_branding -  20
	 * @hooked businesszen_site_navigation -  30
	 * @hooked businesszen_header_end -  50
	 *
	 */
	do_action( 'businesszen_header_action' );

	/**
	 * businesszen_content_start_action hook
	 *
	 * @hooked businesszen_content_start -  10
	 *
	 */
	do_action( 'businesszen_content_start_action' );

	/**
	 * businesszen_header_image_action hook
	 *
	 * @hooked businesszen_header_image -  10
	 *
	 */
	do_action( 'businesszen_header_image_action' );

		if ( businesszen_is_frontpage() ) {
    	$options = businesszen_get_theme_options();
    	$sorted  = array('slider', 'featured_posts', 'popular_posts', 'cta', 'recent_posts', 'recent_posts', 'about', 'subscribe', 'latest_posts');
    	foreach ( $sorted as $section ) {
			if ( $section == 'featured_posts' || $section == 'popular_posts' || $section == 'cta' || $section == 'recent_posts' || $section == 'subscribe' ) {
				add_action( 'businesszen_dairy_primary_content', 'businesszen_dairy_add_'. $section .'_section' );
			}else{
				add_action( 'businesszen_dairy_primary_content', 'businesszen_add_'. $section .'_section' );
			}	
		}

		do_action( 'businesszen_dairy_primary_content' );
	}