<?php
/**
 * Create XSL file
 *
 * @since   0.0.1
 * @author  Daniel Roch
 *
 * @see     public-modules.php
 * @package SEOKEY
 *
 */

// TODO Comments
function seokey_sitemap_output_xsl_file_content($lang) {
	$css         = seokey_sitemap_output_xsl_file_content_css();
	$title       = esc_xml( __( 'XML Sitemap : ' ) );
    $title      .= seokey_helper_cache_data('languages')['lang'][$lang]['name'];
	$description = esc_xml( __( 'This XML Sitemap is generated by SEOKEY to make your content more visible for search engines.', 'seo-key' ) );
	$learn_more  = sprintf(
		'<a target="_blank" href="%s">%s</a>',
		esc_url( __( 'https://www.sitemaps.org/' ) ),
		esc_xml( __( 'Learn more about XML sitemaps.', 'seo-key' ) )
	);
	$returntoindex = sprintf(
		'<a href="%s">%s</a>',
		seokey_helpers_get_sitemap_base_url( $lang, true ).'sitemap-index-'.$lang.'.xml',
		esc_xml( __( 'Return to sitemap index.', 'seo-key' ) )
	);
	$text = __( 'Number of URLs in this XML Sitemap:', 'seo-key' );
    $text .= ' <strong>';
	$text .= sprintf(
        /* translators: %s: Number of URLs. */
        esc_xml( __( '%s contents.', 'seo-key' ) ), '<xsl:value-of select="count( sitemap:urlset/sitemap:url )" />'
    );
	$text .= '</strong>';

	$text2 = ' <strong>' . esc_xml( __( 'No need to manually submit this sitemap to Google. SEOKEY will handle it for you if you connect your search console.', 'seo-key' ) ) . '</strong>';

	$textindex = esc_xml( __( 'This XML Sitemap Index file contains ', 'seo-key' ) );
	$textindex .= '<strong>';
	$textindex .= '<xsl:value-of select="count(sitemap:sitemapindex/sitemap:sitemap)"/>';
	$textindex .= esc_xml( __( ' sitemaps', 'seo-key' ) );
	$textindex .= '</strong>';


	//$lang       = get_language_attributes( 'html' );
	$url        = esc_xml( __( 'URL' ) );
	$lastmod    = esc_xml( __( 'Last Modified' ) );
	$changefreq = esc_xml( __( 'Change Frequency' ) );
	$priority   = esc_xml( __( 'Priority' ) );
	$images     = esc_xml( __( 'Images' ) );

	$xsl_content = <<<XSL
<?xml version="1.0" encoding="UTF-8"?>
	<xsl:stylesheet version="2.0"
		xmlns:html="http://www.w3.org/TR/REC-html40"
		xmlns:image="http://www.google.com/schemas/sitemap-image/1.1"
		xmlns:sitemap="http://www.sitemaps.org/schemas/sitemap/0.9"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="html" encoding="UTF-8" indent="yes"/>

	<!--
	  Set variables for whether lastmod, changefreq or priority occur for any url in the sitemap.
	  We do this up front because it can be expensive in a large sitemap.
	  -->
	<xsl:variable name="has-lastmod"    select="count( /sitemap:urlset/sitemap:url/sitemap:lastmod )"    />
	<xsl:variable name="has-changefreq" select="count( /sitemap:urlset/sitemap:url/sitemap:changefreq )" />
	<xsl:variable name="has-priority"   select="count( /sitemap:urlset/sitemap:url/sitemap:priority )"   />

    
	<xsl:template match="/">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<title>{$title}</title>
				<style>
					{$css}
				</style>
			</head>
			<body>
				<div id="sitemap">
					<div id="sitemap__header">
						<h1>{$title}</h1>
						<p>{$description} - {$learn_more}</p>
						<xsl:if test="count(sitemap:sitemapindex/sitemap:sitemap) &lt; 1">
						    <p>{$returntoindex}</p>
						</xsl:if>
					</div>
					<div id="sitemap__content">
					    <xsl:if test="count(sitemap:sitemapindex/sitemap:sitemap) &gt; 0">
                            <p class="text">
                            	{$textindex}
                            </p>
                            <p class="text">
                                {$text2}
                            </p>
                            <table id="sitemap__table">
                                <thead>
                                <tr>
                                    <th class="loc" width="75%">Sitemap</th>
                                    <th class="lastmod" width="25%">Last Modified</th>
                                </tr>
                                </thead>
                                <tbody>
                                <xsl:for-each select="sitemap:sitemapindex/sitemap:sitemap">
                                    <tr>
                                        <td class="loc">
                                            <a href="{sitemap:loc}"><xsl:value-of select="sitemap:loc"/></a>
                                        </td>
                                        <td class="lastmod">
                                           <xsl:value-of select="concat(substring(sitemap:lastmod,0,11),concat(' ', substring(sitemap:lastmod,12,5)),concat(' ', substring(sitemap:lastmod,20,6)))"/>
                                        </td>
                                    </tr>
                                </xsl:for-each>
                                </tbody>
                            </table>
                        </xsl:if>
                        <xsl:if test="count(sitemap:sitemapindex/sitemap:sitemap) &lt; 1">
                            <p class="text">{$text}</p>
                            <p class="text">{$text2}</p>
                            <table id="sitemap__table">
                                <thead>
                                    <tr>
                                        <th class="loc">{$url}</th>
                                        <xsl:if test="\$has-lastmod">
                                            <th class="lastmod">{$lastmod}</th>
                                        </xsl:if>
                                        <xsl:if test="\$has-changefreq">
                                            <th class="changefreq">{$changefreq}</th>
                                        </xsl:if>
                                        <xsl:if test="\$has-priority">
                                            <th class="priority">{$priority}</th>
                                        </xsl:if>
                                        <th class="images">Images</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <xsl:for-each select="sitemap:urlset/sitemap:url">
                                        <tr>
                                            <td class="loc"><a href="{sitemap:loc}"><xsl:value-of select="sitemap:loc" /></a></td>
                                            <xsl:if test="\$has-lastmod">
                                                <td class="lastmod"><xsl:value-of select="concat(substring(sitemap:lastmod,0,11),concat(' ', substring(sitemap:lastmod,12,5)),concat(' ', substring(sitemap:lastmod,20,6)))"/></td>
                                            </xsl:if>
                                            <xsl:if test="\$has-changefreq">
                                                <td class="changefreq"><xsl:value-of select="sitemap:changefreq" /></td>
                                            </xsl:if>
                                            <xsl:if test="\$has-priority">
                                                <td class="priority"><xsl:value-of select="sitemap:priority" /></td>
                                            </xsl:if>
                                            <xsl:variable name="has-images" select="count(image:image)" />
                                            <xsl:choose>
                                                <xsl:when test="\$has-images">
                                                    <td class="images"><xsl:value-of select="count(image:image)"/> Images</td>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <td class="images">-</td>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </tr>
                                    </xsl:for-each>
                                </tbody>
                            </table>
                        </xsl:if>
					</div>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>

XSL;

	/**
	 * Filters the content of the sitemap stylesheet.
	 *
	 * @since 5.5.0
	 *
	 * @param string $xsl_content Full content for the XML stylesheet.
	 */
	return apply_filters( 'wp_sitemaps_stylesheet_content', $xsl_content );
}




function seokey_sitemap_output_xsl_file_content_css() {
	$text_align = is_rtl() ? 'right' : 'left';
	$css = '
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif;
            color: #444;
        }
    
        #sitemap__table {
            border: solid 1px #ccc;
            border-collapse: collapse;
        }
    
        #sitemap__table tr td.loc {
            /*
             * URLs should always be LTR.
             * See https://core.trac.wordpress.org/ticket/16834
             * and https://core.trac.wordpress.org/ticket/49949
             */
            direction: ltr;
        }
    
        #sitemap__table tr th {
            text-align: ' . $text_align . ';
        }
    
        #sitemap__table tr td,
        #sitemap__table tr th {
            padding: 10px;
        }
    
        #sitemap__table tr:nth-child(odd) td {
            background-color: #eee;
        }
    
        a:hover {
            text-decoration: none;
        }
    ';
	/**
	 * Filters the CSS only for the sitemap stylesheet.
	 *
	 * @since 5.5.0
	 *
	 * @param string $css CSS to be applied to default XSL file.
	 */
	return apply_filters( 'wp_sitemaps_stylesheet_css', $css );
}
