# AI Content Generator for WooCommerce

A WordPress plugin that generates product content using ChatGPT API for WooCommerce products.

## Features

### Existing Features
- **Product Image Generation**: Generate featured images and gallery images based on product details
- **Product Description Generation**: Generate detailed product descriptions with customizable tones
- **Product Short Description Generation**: Generate concise product summaries

### New Features (v1.0.3)
- **Product Brands Generation**: Generate relevant brand suggestions based on product information
- **Product Tags Generation**: Generate SEO-friendly tags and keywords for better product discoverability

## Installation

1. Upload the plugin files to `/wp-content/plugins/ai-content-generator-for-woocommerce/`
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Go to WooCommerce > AI Content Generator to configure your ChatGPT API key

## Configuration

### API Key Setup
1. Get your ChatGPT API key from [OpenAI](https://platform.openai.com/api-keys)
2. Go to WooCommerce > AI Content Generator
3. Enter your API key in the settings
4. Optionally enable debug mode for troubleshooting

## Usage

### Generating Product Content

#### Images
- **Featured Image**: Use the "Generate Featured Image" meta box on the product edit page
- **Gallery Images**: Use the "Generate Gallery Images" meta box to add multiple images

#### Descriptions
- **Main Description**: Click "Generate Description" button in the main content editor
- **Short Description**: Click "Generate Short Description" button in the excerpt editor
- **Tone Selection**: Choose from Formal, Casual, Persuasive, Technical, Luxury, or Creative tones

#### Brands and Tags
- **Brands**: Click "Generate Brands" button next to the product brands field
- **Tags**: Click "Generate Tags" button next to the product tags field
- **Selection**: Check/uncheck generated items before applying to your product

### Workflow
1. Create or edit a WooCommerce product
2. Fill in basic product information (title, categories, etc.)
3. Use the AI generation buttons to create content
4. Review and customize the generated content
5. Apply the content to your product
6. Save the product

## API Requirements

- **ChatGPT API Key**: Required for all AI generation features
- **Model**: Uses GPT-3.5-turbo for text generation and DALL-E for image generation
- **Rate Limits**: Subject to OpenAI's API rate limits

## Debug Mode

When enabled, the plugin logs all API requests and responses to WooCommerce logs with the source 'webtoffee-ai'. This is useful for troubleshooting API issues.

## Requirements

- WordPress 5.0 or higher
- PHP 7.4 or higher
- WooCommerce plugin activated
- ChatGPT API key

## Support

For support and documentation, visit the [User Guide](user-guide-en.html) included with the plugin.

## Changelog

### v1.0.3
- Added product brands generation functionality
- Added product tags generation functionality
- Improved field detection for different WooCommerce setups
- Enhanced error handling and user feedback

### v1.0.2
- Initial release with image and description generation

## License

GPL-2.0+ 